package com.ejie.ab04b.dao.custom;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.comun.UtilDAO;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.Tarea;
import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.ab04b.model.Tramite;
import com.ejie.ab04b.model.TramiteAperturas;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TareaAperturasDaoImpl generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class TareaTramiteAperturasCustomDaoImpl implements
		TareaTramiteAperturasCustomDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_TAREA_063 IDTAREA063, t1.MAILBOX_TASK_ID_063 MAILBOXTASKID063, t1.TIPO_TAREA_063 TIPOTAREA063, t1.ESTADO_063 ESTADO063, t1.FECHA_INI_063 FECHAINI063, t1.FECHA_FIN_063 FECHAFIN063, t1.USUARIO_063 USUARIO063, t1.ID_TRAMITE_063 IDTRAMITE063, t1.ID_TRAMITE_090 IDTRAMITE090, t1.TASK_ID_090 TASKID090, t1.DESCRIPCION_ES_090 DESCRIPCIONES090, t1.DESCRIPCION_EU_090 DESCRIPCIONEU090, t1.ES_INICIAL_090 ESINICIAL090, t1.TIPO_090 TIPO090, t1.ID_TRAMITE_062 IDTRAMITE062, t1.TIPO_TRAMITE_062 TIPOTRAMITE062, t1.TERRIT_APERTURA_062 TERRITAPERTURA062, t1.ANO_APERTURA_062 ANOAPERTURA062, t1.NUM_APERTURA_062 NUMAPERTURA062, t1.PROCEDURE_ID_089 PROCEDUREID089, t1.PROCEEDING_ID_089 PROCEEDINGID089, t1.DESCRIPCION_ES_089 DESCRIPCIONES089, t1.DESCRIPCION_EU_089 DESCRIPCIONEU089 FROM VTAREAS_TRAMITES_APERTURAS t1 ";

	private static final String QUERY_SELECT2 = "SELECT t1.ID_TAREA_063 IDTAREA063, t1.MAILBOX_TASK_ID_063 MAILBOXTASKID063,t2.TASK_TYPE_ID_043 TASKTYPEID043, t1.TIPO_TAREA_063 TIPOTAREA063, t1.ESTADO_063 ESTADO063, t1.FECHA_INI_063 FECHAINI063, t1.FECHA_FIN_063 FECHAFIN063, t1.USUARIO_063 USUARIO063, t1.ID_TRAMITE_063 IDTRAMITE063, t1.ID_TRAMITE_090 IDTRAMITE090, t1.TASK_ID_090 TASKID090, t1.DESCRIPCION_ES_090 DESCRIPCIONES090, t1.DESCRIPCION_EU_090 DESCRIPCIONEU090, t1.ES_INICIAL_090 ESINICIAL090, t1.TIPO_090 TIPO090, t1.ID_TRAMITE_062 IDTRAMITE062, t1.TIPO_TRAMITE_062 TIPOTRAMITE062, t1.TERRIT_APERTURA_062 TERRITAPERTURA062, t1.ANO_APERTURA_062 ANOAPERTURA062, t1.NUM_APERTURA_062 NUMAPERTURA062, t1.PROCEDURE_ID_089 PROCEDUREID089, t1.PROCEEDING_ID_089 PROCEEDINGID089, t1.DESCRIPCION_ES_089 DESCRIPCIONES089, t1.DESCRIPCION_EU_089 DESCRIPCIONEU089, t3.NOTAS_064 AS NOTAS064 FROM VTAREAS_TRAMITES_APERTURAS t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TareaAperturas> rwMap = new RowMapper<TareaAperturas>() {
		public TareaAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			TareaAperturas tarea = new TareaAperturas(
					resultSet.getLong("IDTAREA063"),
					resultSet.getString("MAILBOXTASKID063"), null,
					resultSet.getLong("ESTADO063"),
					resultSet.getTimestamp("FECHAINI063"),
					resultSet.getTimestamp("FECHAFIN063"),
					resultSet.getString("USUARIO063"), new TramiteAperturas(
							resultSet.getLong("IDTRAMITE063")));

			tarea.setTipoTarea(new Tarea(resultSet.getLong("TIPOTAREA063"),
					new Tramite(resultSet.getLong("IDTRAMITE090")), resultSet
							.getString("TASKID090"), resultSet
							.getString("DESCRIPCIONES090"), resultSet
							.getString("DESCRIPCIONEU090"), resultSet
							.getBoolean("ESINICIAL090"), resultSet
							.getString("TIPO090")));

			if (UtilDAO.hasColumn(resultSet, "TASKTYPEID043")) {
				if (resultSet.getString("TASKTYPEID043") != null) {
					tarea.setError(resultSet.getString("TASKTYPEID043"));
				}
			}

			// Notas asociadas a la tarea
			if (UtilDAO.hasColumn(resultSet, "NOTAS064")) {
				tarea.setNotas064(resultSet.getString("NOTAS064"));
			}

			TramiteAperturas tram = new TramiteAperturas(
					resultSet.getLong("IDTRAMITE062"), null, null);

			tram.setApertura(new ComunicacionApertura(resultSet
					.getString("TERRITAPERTURA062"), resultSet
					.getString("ANOAPERTURA062"), resultSet
					.getLong("NUMAPERTURA062")));

			tram.setTipoTramite(new Tramite(
					resultSet.getLong("TIPOTRAMITE062"), resultSet
							.getString("PROCEDUREID089"), resultSet
							.getString("PROCEEDINGID089"), resultSet
							.getString("DESCRIPCIONES089"), resultSet
							.getString("DESCRIPCIONEU089")));

			tarea.setTramiteAperturas(tram);

			return tarea;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 * tareaAperturas TareaAperturas TareaAperturas
	 * 
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @return the tarea aperturas
	 */
	@Transactional(readOnly = true)
	public TareaAperturas vfind(TareaAperturas tareaAperturas) {
		StringBuilder query = new StringBuilder(
				TareaTramiteAperturasCustomDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_TAREA_063 = ? ");

		List<TareaAperturas> tareaAperturasList = this.jdbcTemplate.query(
				query.toString(), this.rwMap, tareaAperturas.getIdTarea063());
		return (TareaAperturas) DataAccessUtils
				.uniqueResult(tareaAperturasList);
	}

	/**
	 * Finds a list of rows in the TareaAperturas table.
	 * 
	 * tareaAperturas TareaAperturas jqGridRequestDto JQGridRequestDto List
	 * <TareaAperturas>
	 * 
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<TareaAperturas> vfindAll(TareaAperturas tareaAperturas,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				TareaTramiteAperturasCustomDaoImpl.QUERY_SELECT2);

		query.append(" LEFT JOIN AB0443T00 t2 on t1.MAILBOX_TASK_ID_063=t2.MAILBOX_TASK_ID_043 ");

		query.append(" LEFT JOIN AB0464T00 t3 on t3.ID_TAREA_064=t1.ID_TAREA_063 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(tareaAperturas);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" ORDER BY t1.FECHA_INI_063 DESC,t1.FECHA_FIN_063 DESC,T1.ESTADO_063 DESC");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<TareaAperturas>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the TareaAperturas entity
	 * 
	 * tareaAperturas TareaAperturas Bean with the criteria values to filter by.
	 * Map created with two keys key query stores the sql query syntax key
	 * params stores the parameter values to be used in the condition sentence.
	 * 
	 * @param tareaAperturas
	 *            the tarea aperturas
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(TareaAperturas tareaAperturas) {

		StringBuilder where = new StringBuilder();
		List<Object> params = new ArrayList<Object>();

		if (tareaAperturas != null && tareaAperturas.getIdTarea063() != null) {
			where.append(" AND t1.ID_TAREA_063 = ?");
			params.add(tareaAperturas.getIdTarea063());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getTramiteAperturas() != null
				&& tareaAperturas.getTramiteAperturas().getIdTramite062() != null) {
			where.append(" AND t1.ID_TRAMITE_063 = ?");
			params.add(tareaAperturas.getTramiteAperturas().getIdTramite062());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getMailboxTaskId063() != null) {
			where.append(" AND t1.MAILBOX_TASK_ID_063 = ?");
			params.add(tareaAperturas.getMailboxTaskId063());
		}
		if (tareaAperturas != null && tareaAperturas.getEstado063() != null) {
			where.append(" AND t1.ESTADO_063 = ?");
			params.add(tareaAperturas.getEstado063());
		}
		if (tareaAperturas != null && tareaAperturas.getFechaIni063() != null) {
			where.append(" AND t1.FECHA_INI_063 = ?");
			params.add(tareaAperturas.getFechaIni063());
		}
		if (tareaAperturas != null && tareaAperturas.getFechaFin063() != null) {
			where.append(" AND t1.FECHA_FIN_063 = ?");
			params.add(tareaAperturas.getFechaFin063());
		}
		if (tareaAperturas != null && tareaAperturas.getUsuario063() != null) {
			where.append(" AND t1.USUARIO_063 = ?");
			params.add(tareaAperturas.getUsuario063());
		}

		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getIdTarea090() != null) {
			where.append(" AND t1.TIPO_TAREA_063 = ?");
			params.add(tareaAperturas.getTipoTarea().getIdTarea090());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getTramite() != null
				&& tareaAperturas.getTipoTarea().getTramite().getIdTramite089() != null) {
			where.append(" AND t1.ID_TRAMITE_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getTramite()
					.getIdTramite089());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getTaskId090() != null) {
			where.append(" AND t1.TASK_ID_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getTaskId090());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getDescripcionEs090() != null) {
			where.append(" AND t1.DESCRIPCION_ES_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getDescripcionEs090());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getDescripcionEu090() != null) {
			where.append(" AND t1.DESCRIPCION_EU_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getDescripcionEu090());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getEsInicial090() != null) {
			where.append(" AND t1.ES_INICIAL_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getEsInicial090());
		}
		if (tareaAperturas != null && tareaAperturas.getTipoTarea() != null
				&& tareaAperturas.getTipoTarea().getEsInicial090() != null) {
			where.append(" AND t1.TIPO_090 = ?");
			params.add(tareaAperturas.getTipoTarea().getEsInicial090());
		}

		if (tareaAperturas != null
				&& tareaAperturas.getTramiteAperturas() != null
				&& tareaAperturas.getTramiteAperturas().getApertura() != null
				&& tareaAperturas.getTramiteAperturas().getApertura()
						.getTerape056() != null) {
			where.append(" AND t1.TERRIT_APERTURA_062 = ?");
			params.add(tareaAperturas.getTramiteAperturas().getApertura()
					.getTerape056());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getTramiteAperturas() != null
				&& tareaAperturas.getTramiteAperturas().getApertura() != null
				&& tareaAperturas.getTramiteAperturas().getApertura()
						.getAnoape056() != null) {
			where.append(" AND t1.ANO_APERTURA_062 = ?");
			params.add(tareaAperturas.getTramiteAperturas().getApertura()
					.getAnoape056());
		}
		if (tareaAperturas != null
				&& tareaAperturas.getTramiteAperturas() != null
				&& tareaAperturas.getTramiteAperturas().getApertura() != null
				&& tareaAperturas.getTramiteAperturas().getApertura()
						.getNumape056() != null) {
			where.append(" AND t1.NUM_APERTURA_062 = ?");
			params.add(tareaAperturas.getTramiteAperturas().getApertura()
					.getNumape056());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	@Override
	public TareaAperturas vfindTareaEnElMismoAno(TareaAperturas tareaAperturas) {
		StringBuilder query = new StringBuilder(
				TareaTramiteAperturasCustomDaoImpl.QUERY_SELECT);

		query.append(" INNER JOIN AB0456S00 t2 ON(t1.TERRIT_APERTURA_062=t2.terape_056 and t1.ANO_APERTURA_062=t2.anoape_056 and t1.NUM_APERTURA_062=t2.numape_056) "
				+ " where T2.NUMDOC_056=? AND T2.TIPDOC_056=? "
				+ " AND t1.TASK_ID_090= ?"
				+ " AND EXTRACT(YEAR FROM t1.FECHA_FIN_063) = EXTRACT(YEAR FROM SYSDATE) and  rownum=1 ");

		List<TareaAperturas> tareaAperturasList = this.jdbcTemplate.query(query
				.toString(), this.rwMap, tareaAperturas.getTramiteAperturas()
				.getApertura().getNumdoc056(), tareaAperturas
				.getTramiteAperturas().getApertura().getTipdoc056(),
				tareaAperturas.getTipoTarea().getTaskId090());
		return (TareaAperturas) DataAccessUtils
				.uniqueResult(tareaAperturasList);
	}

}
